[ServeContent], [ServeFile], and [ServeFileFS] now remove
the `Cache-Control`, `Content-Encoding`, `Etag`, and `Last-Modified`
headers when serving an error. These headers usually apply to the
non-error content, but not to the text of errors.

Middleware which wraps a [ResponseWriter] and applies on-the-fly
encoding, such as `Content-Encoding: gzip`, will not function after
this change.  The previous behavior of [ServeContent], [ServeFile],
and [ServeFileFS] may be restored by setting
`GODEBUG=httpservecontentkeepheaders=1`.

Note that middleware which changes the size of the served content
(such as by compressing it) already does not function properly when
[ServeContent] handles a Range request. On-the-fly compression
should use the `Transfer-Encoding` header instead of `Content-Encoding`.

